library(memisc)
library(mestats)

load("voteint-classd-churchat-cmp.RData")


voteint.classd.work <- subset(voteint.classd.cmp,
    as.numeric(classd) %in% 1:4 &
                    nation %in% c(
                              "France",
                              "Belgium",
                              "Netherlands",
                              "Germany West",
                              "Italy",
                              "Danmark",
                              "Great Britain"
                              ) &
                    year > 1974 #& year <= 1994
                    & (! (nation == "Italy" & year > 1992) )
)

voteint.classd.work <- within(voteint.classd.work,{
      choice.set <- interaction(classd,eb,nation)
      Time <- (year - min(year))/(max(year)-min(year)) - .5
    })

mclogit.classd <- mclogit(cbind(Freq,choice.set)~
                I(econdim^2)+I(authlib^2)+I(tradmod^2)+
                econdim/(classd*Time)+
                authlib/(classd*Time)+
                tradmod/(classd*Time),
         data=voteint.classd.work,
         random=~1|party/eb)

summary(mclogit.classd)

save(mclogit.classd,file="mclogit-classd.RData")
